"Macro Data Sheet file v. 1" 
gamesystem GURPS 

title "GURPS Psionics (v. 3.0.0)" 

version 253
level 3

copyright "Copyright  1987-2001 Steve Jackson Games Incorporated. All rights reserved. \
GURPS is a registered trademark of Steve Jackson Games Incorporated."

$$define PLUGIN P

$$include gurps.inc

logo GURPS/Psionics.lgo


cat Advantages
	sublist "Psionics" memlist
		$$cadv(Being of Pure Thought, 290)
		$$ladv(Mindlink, 1)
		$$ladv(Psionic Resistance, 2)
		end
	end

cat Powers
	sublist "Psionics" memlist
		sublist "Pside Effects" memlist
			# These don't count against normal disadvantages.
			$$nadv("Special Pside Effect", , "$Trivial;1;Inconvenient;2", -x, x=1 or x=2,
				"$totalItems('Powers:Special Pside Effect',0,-1,'cost')>=-5::No more than -5 points of Special Effects allowed",
				Special Pside Effect)
			$$ladv(Pside Effect Drawback, -5, , , x<=3 and x>0, 
				"$totalItems('Powers:Pside Effect Drawback',0,-1,'cost')>=-15::No more than -15 points of Drawbacks allowed",
				Pside Effect Drawback)
				opt	exp Reaction "x*`Noticeable`"
					text Noticeable "?:1;Sometimes,-2;Rarely,-3"
					end
			end

		sublist Antipsi memlist
			$$psipower	Antipsi	3		Neutralize=0;Psi Static=0
				opt
					percent "Affects One Power" "?+0;-50%"
					end
			$$psipower	Neutralize	2	Antipsi
				opt
					percent "Affects One Power" "?+0;-50%"
					end
			$$psipower	Psi Static	2	Antipsi
				opt
					percent "Affects One Power" "?+0;-50%"
					end
			end
		sublist "Astral Projection" memlist
			$$psipower	Astral Projection	3		Astral Projection=0;Astral Sight=0
				opt
					percent "Astral Body Is Visible" "?+0;-30%"
					end
			$$psipower	Astral Sight	1	Astral Projection
			end
		sublist Electrokinesis memlist
			$$psipower	Electrokinesis	5		Energy Sense=0;Confuse=0;Cyberpsi=0;Dampen=0;Energy Shield=0;Surge=0;Lightning=0
			$$psipower	Confuse	2	Electrokinesis	
			$$psipower	Cyberpsi	2	Electrokinesis
			$$psipower	Dampen	2	Electrokinesis
			$$psipower	Energy Sense	1	Electrokinesis
			$$psipower	Energy Shield	2	Electrokinesis
			$$psipower	Photokinesis	2	Electrokinesis
			$$psipower	Surge	2	Electrokinesis
			end
		sublist ESP memlist
			$$psipower	Clairvoyance	2	ESP
				opt
					percent "Does Not Work in Darkness" "?+0;-50%"
					end
			$$psipower	Clairaudience	2	ESP
			$$psipower	Clairsentience	1	ESP
			$$psipower	Combat Sense	2	ESP
			$$psipower	ESP	3		Clairvoyance=0;Clairaudience=0;Clairsentience=0;Precognition=0;Psychometry=0
			$$psipower	Precognition	2	ESP
			$$psipower	Psychometry	1	ESP
			$$psipower	Seekersense	2	ESP
			end
		sublist "Psionic Healing" memlist
			$$psipower	Psionic Healing	3		Metabolism Control=0;Sense Aura=0;Psionic Healing=0
				opt
					percent "Take Half Damage Healed" "?+0;-50%"
					percent "Cannot Heal Self" "?+0;-50%"
					percent "Can Heal Only Self" "?+0;-30%"
					end
			$$psipower	Metabolism Control	1	Psionic Healing
			$$psipower	Sense Aura	1	Psionic Healing
			end
		sublist "Psychic Vampirism" memlist
			$$psipower	Drain ST	2	Psychic Vampirism
			$$psipower	Drain DX	2	Psychic Vampirism
			$$psipower	Drain IQ	2	Psychic Vampirism
			$$psipower	Drain HT	2	Psychic Vampirism
			$$psipower	Drain Emotion	2	Psychic Vampirism
			$$psipower	Psychic Vampirism	3		Drain Emotion=0;Steal Dreams=0;Steal Energy=0;Steal Power=0;Drain ST=0;Drain DX=0;Drain IQ=0;Drain HT=0
				opt
					percent "Eye Contact Only" "?+0;-20%"
					end
			$$psipower	Steal Dreams	2	Psychic Vampirism
			$$psipower	Steal Energy	2	Psychic Vampirism
			$$psipower	Steal Power	2	Psychic Vampirism
			end
		sublist Psychokinesis memlist
			$$psipower	Cryokinesis	2	Psychokinesis
			$$psipower	Levitation	3	Psychokinesis
				opt
					percent "Vertical Movement Only" "?+0;-50%"
					end
			$$psipower	PK Shield	2	Psychokinesis
			$$psipower	Psychokinesis	5		Cryokinesis=0;Levitation=0;Telekinesis=0;Pyrokinesis=0
			$$psipower	Pyrokinesis	3	Psychokinesis
				opt
					percent "Improved Control" "?+0;+20%"
					end
			$$psipower	Telekinesis	4	Psychokinesis
			end
		sublist Telepathy memlist
			$$psipower	Aspect	2	Telepathy
				opt
					percent "Double Reaction Bonus for Opposite Sex" "?+0;+50%"
					end
			$$psipower	Emotion Sense	2	Telepathy
			$$psipower	Erase Signature	1	Telepathy
			$$psipower	Mind Shield	2	Telepathy
			$$psipower	Psi Sense	1	Telepathy
			$$psipower	Signature Sniffer	1	Telepathy
			$$psipower	Telepathy	5		Emotion Sense=0;Mind Shield=0;Telereceive=0;Telesend=0	EmpathyBonus+1;Skills:DetectLies+0;Skills:Psychology+0
			$$psipower	Telereceive	3	Telepathy
			$$psipower	Telescan	2	Telepathy
			$$psipower	Telesend	3	Telepathy
				opt
					percent "Cannot Lie with Telesend" "?+0;-30%"
					end
			end
		sublist Teleportation memlist
			$$psipower	Autoteleport	4	Teleportation
				opt
					percent "May Carry Nothing" "?+0;-50%"
					percent "Inertia Maintained" "?+0;-50%"
					percent "Material Not Exchanged" "?+0;-20%"
					percent "Deadly Teleport Intersection" "?+0;-50%"
					percent "Memorize Any Number of Locations" "?+0;+40%"
					end
			$$psipower	Exoteleport	4	Teleportation
				opt
					percent "Only Bring Objects" "?+0;-40%"
					percent "Only Send Objects" "?+0;-40%"
					end
			$$psipower	Teleportation	5		Autoteleport=0;Exoteleport=0
				opt
					percent "May Carry Nothing" "?+0;-50%"
					percent "Inertia Maintained" "?+0;-50%"
					percent "Material Not Exchanged" "?+0;-20%"
					percent "Deadly Teleport Intersection" "?+0;-50%"
					percent "Memorize Any Number of Locations" "?+0;+40%"
					end
			end
		end
	end


cat Skills
	sublist "Psionics" memlist
		$$skill(Mind Block, MA!, "Psionic", "iq+Will-4#Will")
		sublist Antipsi memlist
			$$psisk	Neutralize	2	Antipsi		0	$'`Power` yd'	subject		HT/Will	10
				opt
					percent "Affects One Power" "?+0;-50%"
					end
			$$psisk	Psi Static	2	Antipsi		0	0	$dtprange(tprange(`Power`)/100)	infinite	spcl.	10
				opt
					percent "Affects One Power" "?+0;-50%"
					end
			end
		sublist "Astral Projection" memlist
			$$psisk	Astral Projection		Astral Projection		0		self	
			$$psisk	Astral Sight	1	Astral Projection		0	$format('%d yd', `Power`*`Power`)	self	infinite		11
				opt
					percent "Share Ability" "?+0;+40%"
					end
			end
		sublist Electrokinesis memlist
			$$psisk	Confuse	2	Electrokinesis		0	$'`Power` yd'	subject		HT	11
			$$psisk	Cyberpsi	2	Electrokinesis		0	$'`Power` yd'	subject	min.	Spcl.	11
			$$psisk	Dampen	2	Electrokinesis		0	$format('%d yd',`Power`*`Power`)	$dtprange(`Power`/4)	min.	Spcl.	12
			$$psisk	Energy Sense	1	Electrokinesis		0	$dtprange(`Power`)	self	infinite		12
			$$psisk	Energy Shield	2	Electrokinesis		0		subject		12
			$$psisk	Lightning		Electrokinesis		0	Spcl.	subject		Dodge	12
			$$psisk	Photokinesis	2	Electrokinesis		0	$dtprange(`Power`*`Power`)	subject		Spcl.	13
				opt
					percent "For Invisibility Only" "?+0;-50%"
					end
			$$psisk	Surge	2	Electrokinesis		0	$dtprange(`Power`*`Power`)	subject		Spcl.	13
			end
		sublist ESP memlist
			$$psisk	Clairaudience	2	ESP		0	$dispInch(`Power`*`Power`)	$dispInch(`Power`*`Power`/2)	min.		13
			$$psisk	Clairvoyance	2	ESP		0	$dtprange(`Power`*`Power`)	$dtprange(`Power`*`Power`/2)	min.		14
				opt
					percent "Does Not Work in Darkness" "?+0;-50%"
					end
			$$psisk	Clairsentience	1	ESP		0	$dispInch(`Power`*`Power`)	$dispInch(`Power`*`Power`/2)	min.		14
			$$psisk	Combat Sense	2	ESP	Powers:ESP>=10	0		self	sec.		14
			$$psisk	Precognition	2	ESP		2	$dtprange(tprange(`Power`))	subject			14
				opt
					percent "Works Only in Dreams" "?+0;-30%"
					percent "Special Circumstances" "?+0;-10%"
					end
			$$psisk	Psychometry	1	ESP		0	$dispInch(`Power`*`Power`)	subject			13
				opt
					exp "Length of History" "format('%d years',`Power`*`Power`*(`Power`<15?1:`Power`))"
					begin percent "Special Circumstances" "?+0;-10%" keepold end
					end
			$$psisk	Seekersense	2	ESP		0	$dtprange(tprange(`Power`))	subject		Spcl.	15
			end
		sublist "Psionic Healing" memlist
			$$psisk	Psionic Healing		Psionic Healing		var.	touch	subject			15
				opt
					percent "Take Half Damage Healed" "?+0;-50%"
					percent "Cannot Heal Self" "?+0;-50%"
					percent "Can Heal Only Self" "?+0;-30%"
					end
			$$psisk	Life Extension		Psionic Healing	Metabolism Control>=14	0		self	infinite		15
			$$psisk	Metabolism Control	1	Psionic Healing		0		self	var.		15
			$$psisk	Sense Aura	1	Psionic Healing		0	$dtprange(`Power`-1)	self	min.		16
			end
		sublist "Psychic Vampirism" memlist
			$$psisk	Drain ST	2	Psychic Vampirism		0	$dtprange(`Power`*`Power`)	subject		Spcl.	16
			$$psisk	Drain DX	2	Psychic Vampirism		0	$dtprange(`Power`*`Power`)	subject		Spcl.	16
			$$psisk	Drain IQ	2	Psychic Vampirism		0	$dtprange(`Power`*`Power`)	subject		Spcl.	16
			$$psisk	Drain HT	2	Psychic Vampirism		0	$dtprange(`Power`*`Power`)	subject		Spcl.	16
			$$psisk	Drain Emotion	2	Psychic Vampirism		0	$dtprange(`Power`*`Power`)	subject		Will+MS	16
			$$psisk	Steal Dreams	2	Psychic Vampirism		0	$dtprange(tprange(`Power`))	subject		Will+MS	17
			$$psisk	Steal Energy	2	Psychic Vampirism		0	$dtprange(`Power`)	sujbect		Will+MS	17
			$$psisk	Steal Power	2	Psychic Vampirism		1	$dtprange(`Power`)	sujbect		Will+MS	17
			end
		sublist Psychokinesis memlist
			$$psisk	Cryokinesis	2	Psychokinesis		0	PK	subject			17
			$$psisk	Levitation	3	Psychokinesis		0		self			18
				adj "Sk:Flight+`Add to Skill`*integer(x/8)"
				opt
					begin text "Add to Skill" "?+0;" dispexp "'l'" noprint end
					percent "Vertical Movement Only" "?+0;-50%"
					end
			$$psisk	PK Shield	2	Psychokinesis	Powers:ESP	1		self	sec.		18
			$$psisk	Pyrokinesis	3	Psychokinesis		0	PK	subject			18
				opt
					percent "Improved Control" "?+0;+20%"
					end
			$$psisk	Telekinesis	4	Psychokinesis		0	PK	subject	min.		19
			end
		sublist Telepathy memlist
			$$psisk	Aspect	2	Telepathy	Powers:Telepathy>=10	0		$dtprange(tprange(`Power`)/100)			20
				opt
					percent "Double Reaction Bonus for Opposite Sex" "?+0;+50%"
					end
			$$psisk	Emotion Sense	2	Telepathy		0	$dtprange(tprange(`Power`))	subject	infinite	MS	20
			$$psisk	Erase Signature	1	Telepathy		0	$dtprange(tprange(`Power`))	subject		MS	20
			$$psisk	Illusion		Telepathy		0	$dtprange(tprange(`Power`))	subject	min.	Will	21
				opt
					percent "Usable Against Groups" "?+0;+50%"
					percent "For Invisibility Only" "?+0;-50%"
					end
			$$psisk	Mental Blow		Telepathy	Telesend>=12	1	$dtprange(tprange(`Power`))	subject		MS	21
				opt	exp "Damage" "format('Mental stun%s', PSI_Telepathy < 10 ? '' : format(', %dd%s Fatigue', integer(PSI_Telepathy/10), PSI_Telepathy mod 10 > 5 ? '+1' : ''))"
					end
			$$psisk	Mental Stab		Telepathy	Mental Blow>=15	2	$dtprange(tprange(`Power`))	subject		MS	22
				opt	exp "Damage" "format('%d HT', integer(PSI_Telepathy/5))"
					end
			$$psisk	Mind Shield	2	Telepathy		
			$$psisk	Mind Switch		Telepathy	Telereceive>=14;Telesend>=14	3	$dtprange(tprange(`Power`))	subject		Will+5	23
				opt
					percent "Transfer to One Specific Mind" "?+0;-50%"
					end
			$$psisk	Mindsword		Telepathy	Mental Blow>=12	0	Spcl.		min.		23
				opt	exp "Damage" "format('%s Fatigue, %s HT', swing(PSI_Telepathy,0), thrust(PSI_Telepathy, 0))"
					end
			$$psisk	Mindwipe		Telepathy	Telereceive>=12;Telesend>=12	0	$dtprange(tprange(`Power`))	subject		Will	23
			$$psisk	Psi Sense	1	Telepathy		0	0	$dtprange(tprange(`Power`))		MS	24
			$$psisk	Signature Sniffer	1	Telepathy	Powers:ESP>=1	0	0	subject		Spcl.	24
			$$psisk	Sleep		Telepathy	Telesend>=12	0	$dtprange(tprange(`Power`))	subject		Will	24, 39
				opt
					percent "Usable Against Groups" "?+0;+100%"
					end
			$$psisk	Suggest		Telepathy	Telesend>=12;Telereceive>=12	1	$dtprange(tprange(`Power`))	subject		Will	24
			$$psisk	Telecontrol		Telepathy	Telesend>=15;Telereceive>=15	0	$dtprange(tprange(`Power`))	subject	min.	Will	25
				opt
					percent "Must Enter Trance" "?+0;-30%"
					end
			$$psisk	Telereceive	3	Telepathy		0	$dtprange(tprange(`Power`))	subject	min.	Will+MS	25
			$$psisk	Telescan	2	Telepathy		0	$dtprange(tprange(`Power`))	$dtprange(tprange(`Power`))	min.	MS	26
			$$psisk	Telesend	3	Telepathy		0	$dtprange(tprange(`Power`))	subject	min.	MS	26
				opt
					percent "Cannot Lie with Telesend" "?+0;-30%"
					end
			end
		sublist Teleportation memlist
			$$psisk	Autoteleport	4	Teleportation		0	 $dtprange(tprange(`Power`))	self			27
				opt
					percent "May Carry Nothing" "?+0;-50%"
					percent "Inertia Maintained" "?+0;-50%"
					percent "Material Not Exchanged" "?+0;-20%"
					percent "Deadly Teleport Intersection" "?+0;-50%"
					percent "Memorize Any Number of Locations" "?+0;+40%"
					end
			$$psisk	Combat Teleport		Teleportation	Powers:Teleportation>=10;Autoteleport>=14	1	$dtprange(tprange(`Power`)/100)	self			27
			$$psisk	Exoteleport	4	Teleportation		0	$dtprange(tprange(`Power`))	subject			27	
				opt
					percent "Only Bring Objects" "?+0;-40%"
					percent "Only Send Objects" "?+0;-40%"
					end
			end
		end
	end

cat Equipment
	sublist "Psionics" memlist
		sublist "Mundane Technology" memlist
			$$gadget	Psionic Testing Equipment	400	100000	6	Av	7	59
			$$gadget	Sensory Deprivation Box	800	10000	6	Av	7	59
			$$gadget	Deepsleep Box	2	500	6	S	7	59
			$$gadget	Brainscanner	4	6000	Av	8	60
			end
		sublist "Interface Technology" memlist
			$$gadget	Psiberface Helmet	4	4000	6	C	7	60
			$$gadget	Psiberface Implant		4000	6	C	7	60
				opt text "Operation Cost" +2000 end
			$$gadget	Tele-Switch		200	5	S	8	60
			$$gadget	Secure Tele-Switch		1000	6	Av	9	61
			$$gadget	Telepathic Control Panel		10000	6	Av	10	61
			$$gadget	Secure Telepathic Control Panel		100000	6	Av	10	61
			end
		sublist "Psionic Amplifiers" memlist
			$$gadget	Amplifier Throne	1000	200000	3	Am	8	61
			$$gadget	Amplifier Throne Extra Power	500	100000	3	Am	8	61
			$$gadget	Backpack Psi-Amplifier	20	40000	4	Am	8	61
			$$gadget	Backpack Psi-Amplifier Extra Power	10	20000	4	Am	8	61
			$$gadget	Amplifier Helmet	4	25000	5	Am	8	61
			$$gadget	Amplifier Helmet Extra Power	1	10000	5	Am	8	61
			$$gadget	Amplifier Headband	1	6250	5	Am	10	61
			$$gadget	Amplifier Headband Extra Power	0.5	2500	5	Am	10	61
			end
		sublist "Other Augmentation Devices" memlist
			$$gadget	Gestalt Web	1200	100000	3	Am	10	61
			$$gadget	Gestalt Web Extra Mind	100	20000	3	Am	10	61
			$$gadget	World-Web Terminal	20	2000	5	Av	11	61
			$$gadget	Web Central Processor	50000	25000000	1	Am	11	62
			$$gadget	Psionic Computer	2000	2000000	2	C	9	62
			$$gadget	Psionic Computer Psionic Power Level	0	10000	2	C	9	62
			$$gadget	Psionic Computer Program	0	100000	2	C	9	62
			end
		sublist "Communication and Information Equipment" memlist
			$$gadget	Memory Crystal	0.5	2000	6	Av	8	63
			$$gadget	Deathscanner	12	80000	5	C	9	63
			$$gadget	Mind Probe	400	120000	3	Am	9	64
			$$gadget	Thought Globe	0.5	5000	6	C	9	64
			$$gadget	Psitector	1	1000	6	Av	8	64
			$$gadget	Psiscanner	2	10000	5	C	9	64
			$$gadget	Mindscanner	20	6000	6	Av	8	65
			$$gadget	Psychic Lock	0.5	500	6	Av	10	65
			$$gadget	Empathic Lock	0.5	500	6	Av	10	65
			$$gadget	Life Field Detector	4	4000	6	Av	9	65
			end
		sublist "Dream Technology" memlist
			$$gadget	Dreamscanner	20	150000	5	C	9	65
			$$gadget	Dreamcorder	10	40000	6	C	10	66
			end
		sublist "Covert Operations Equipment" memlist
			$$gadget	Mind Control Implant	0	4000	2	Av	8	67
			$$gadget	Mind Control Implant Operation Cost	0	2000	2	Av	8	67
			$$gadget	Mind Control Headband	0.5	6000	2	Av	9	67
			$$gadget	Empathic Sink	1	3000	3	C	10	67
			$$gadget	Empathic Sink Implant	0	2000	2	C	10	67
			$$gadget	Empathic Sink Implant Operation Cost	0	1000	2	C	10	67
			$$gadget	Mind Transfer Machine	1000	10000000	3	Am	10	67
			end
		sublist "Healing Technology" memlist
			$$gadget	Auric Scanner	400	10000	6	Av	9	68
			$$gadget	Biointensifier	600	20000	5	C	10	68
			end
		sublist	"Psychokinetic Technology" memlist
			$$gadget	Kinetic Bubble	0.25	20000	6	C	10	68
			$$gadget	PK Battery AA	0.000125	20	6	Av	8	68
			$$gadget	PK Battery A	0.0025	100	6	Av	8	68
			$$gadget	PK Battery B	0.05	300	6	Av	8	68
			$$gadget	PK Battery C	0.5	1000	6	Av	8	68
			$$gadget	PK Battery D	5	5000	6	Av	8	68
			$$gadget	PK Battery E	20	20000	6	Av	8	68
			$$gadget	EK Battery AA	0.000125	20	6	Av	8	68
			$$gadget	EK Battery A	0.0025	100	6	Av	8	68
			$$gadget	EK Battery B	0.05	300	6	Av	8	68
			$$gadget	EK Battery C	0.5	1000	6	Av	8	68
			$$gadget	EK Battery D	5	5000	6	Av	8	68
			$$gadget	EK Battery E	20	20000	6	Av	8	68
			$$gadget	Psiberplas Clothing	2	500	6	C	10	69
			end
		sublist "Teleportation Technology" memlist
			$$gadget	Jump Beacon Power 5	20	15000	Var	Am	11	69
			$$gadget	Jump Beacon Power 10	500	80000	Var	Am	11	69
			$$gadget	Jump Beacon Power 15	1000	200000	Var	Am	11	69
			$$gadget	Jump Beacon Power 20	1000	250000	Var	Am	11	69
			$$gadget	Jump Beacon Power +1	0	10000	Var	Am	11	69
			$$gadget	Actuality Shield / lb	0	10000	5	C	11	69
			$$gadget	Blinksat System	0	0	Var	Var	11	69
			$$gadget	Psionic Stardrive	20000	50000000	4	Am	10	70
			$$gadget	Psionic Stardrive / 100t	2000	5000000	4	Am	10	70
			end
		sublist "Psychotronic Weaponry" memlist
			$$gadget	Hypnagogic Web	2	100000	0	Av	8	70
			$$gadget	Hypnagogic Web Implant	0	100000	0	C	9	70
			$$gadget	Hypnagogic Web Implant Operation	0	2000	0	C	9	70
			$$gadget	Telestatic Field Projector	0.5	2000	3	Av	9	70
			$$gun(Psychosynaptic Disruptor Pistol, BeamWeapon, , Spcl., , 7, 4, 10, 25, 2, 1, 8/B, , 0, 2000, 10, LC 3)
			$$gun(Psychosynaptic Disruptor Rifle, BeamWeapon, , Spcl., , 10, 7, 25, 100, 8, 1, 20/C, , 0, 5200, 10, LC 2)
			$$gun(Psychosynaptic Disrupter Semi-Portable, BeamWeapon, , Spcl, , 12, 10, 50, 200, 30, 1, 40/D, 15, 0, 20000, 10, LC 1)
			$$gadget	Empathic Mirror	1	7000	5	C	10	71
			$$gadget	Bodyshield	2	10000	3	C	11	71
			$$gadget	Psiberplas Bodyshield	2	11000	3	C	11	71
			end
		sublist "Support Weaponry" memlist
			$$gadget	Thimble Psi-Bomb	.25	100	3	Av	8	72
			$$gadget	Grenade Psi-Bomb	1	200	2	Av	8	72
			$$gadget	Satchel Psi-Bomb	10	1000	1	Av	8	72
			$$gadget	Terror Psi-Bomb	200	10000	0	Av	8	72
			$$gadget	Psibermine	6	500	1	C	9	72
			$$gadget	Fear Extractor	120	80000	3	C	10	72
			$$gadget	Mindseeker	0	0	1	C	8	72	Doubles cost of guided weapon.
			$$gadget	Thanatos Field Generator	220	140000	1	Am	10	73
			$$gadget	Exterminator	220	140000	4	Am	10	73
			end
		sublist "Anti-Psi Technology" memlist
			$$gadget	P-Web	0.5	1200	4	S	7	73
			$$gadget	Psionic Shield Helmet	1.5	1000	5	Av	8	73
			$$gadget	Psionic Shield Helmet Added To Combat Helmet	1	1000	5	Av	8	73
			$$gadget	Mini-Shield	0	1000	5	Av	8	74
			$$gadget	Neutralizer	2	6000	5	C	9	74
			$$gadget	Pocket Damper	2	6000	6	Av	9	74
			$$gadget	Portable Null	10	10000	4	Av	8	74
			$$gadget	Psi-Impeder	0.25	600	3	Av	8	74
			$$gadget	Psi-Impeder Punishment Circuit	0	400	3	Av	8	74
			$$gadget	Psi-Impeder Implant	0	600	3	Av	8	74
			$$gadget	Psi-Impeder Implant Operation	0	600	3	Av	8	74
			$$gadget	Psi-Impeder Implant Punishment Circuit	0	400	3	Av	8	74
			end
		sublist "Bio-Psi Technology" memlist
			$$gadget	Drone Brain	0	12000	Spcl.	n/a	8	81
			$$gadget	Drone Surgery	0	10000	Spcl.	n/a	8	81
			$$gadget	Power Virus / Pt Cost of Power	0	10000	2	Am	10	81
			$$gadget	Null Virus / Pt Cost of Power	0	1000	1	C	9	81
			$$gadget	Overmind Virus	0	20000	0	Am	10	81
			$$gadget	Metamorphosis	0	50000	0	Am	10	81
			$$gadget	Symbiotic Crystal	0	100000	4	Am	13	82
			$$gadget	Watchdog	20	7200	4	Av	8	83
			$$gadget	Guardian	60	32000	3	C	9	83
			$$gadget	Inquisitor	200	200000	3	C	9	83
			$$gadget	Sponge	20	50000	3	C	8	83
			$$gadget	Brain Tissue Graft	0	20000	1	C	8	83
			$$gadget	Neuro-Psi Implant	0.5	150000	5	Am	11	84
			$$gadget	Neuro-Psi Implant Operation	0	2000	5	Am	11	84
			end
		sublist "Psi-Drugs" memlist
			$$drug	Blue Fire	100	7	2	Av	Hypo or Pill	78
			$$drug	Brainstorm	150	8	1	Av	Hypo	78
			$$drug	Catalyst Drug	1000	8	3	Av	Hypo or Pill	79
			$$drug	Mind Hype	100	8	4	Av	Hypo	79
			$$drug	Monobloc	60	8	4	S	Pill	79
			$$drug	Psibooster / Pt Cost of Power	250	8	3	C	Hypo	79
			$$drug	Shatter	20	8	2	C	Hypo, Pill, Gas	80
			$$drug	Shiver	40	10	4	Av	Hypo or Pill	80
			$$drug	Trance	15	8	4	Av	Hypo or Pill	80
			end
		end
	end

options
	list "Psionics"
		list Enhancements
			begin percent "Extended Duration" "??1;30;x*30;x>0" dispexp "format('l: %d, +o%%',2^(o/30))" end
			percent Instantaneous +20%
			percent "Movable Area" +40%
			percent "No Signature" +20%
			percent "Weak Signature" +10%
			begin percent "Reduced Fatigue Cost" "??1;20;x*20;x>0"
				dispexp "'l: -t, +o%'"
				end
			percent "Selective Effect" +50%
			end
		list Limitations
			begin percent "Accessibility" "??10;-10;-x;x>0"
				dispexp "'l: o%'"
				end

			percent "Not Usable Under Stress" -60%
			percent "Usable Only vs. Non-Psis" -50%
			percent "Usable Only vs. Psis" -50%
			percent "Usable Only in Hypnotic Trance" -30%
			percent "Usable Only by One Side of Split Personality" -30%

			begin percent "Costs Fatigue" "??1;-5;-x*5;x>0 and x<=10"
				dispexp "'l: t, o%'"
				end
			begin percent "Differential Effect" "??10;-10;-x;x>0"
				dispexp "'l: o%'"
				end
			percent "Emergencies Only" "?:1;At All,-30%;At Full Power,-20%"
			percent "Eye Contact Only" "?+1;-20%"
			percent Fickle "?:1;14 or less,-10%;11 or less,-20%;8 or less,-30%;5 or less,-70%"
			begin percent "Nuisance Effect" "??10;-10;-x;x>0"
				dispexp "'l: o%'"
				end
			percent "Preparation Required" "?:1;1 min.,-20%;10 min.,-30%;1 hr.,-50%;8 hrs.,-60%"
			begin percent "Reduced Range" "??1;1;-x*5;x>0 and x<=3"
				dispexp "format('l: /%d, o%%',2^t)"
				end
			begin percent "Takes Extra Time" "??1;-10;-x*10;x>0"
				dispexp "format('l: %d, o%%',2^t)"
				end
			percent "Takes Recharge" "?:1;5 sec.,-10%;15 sec.,-20%;1 hr.,-30%"
			percent "Close Contact" "?:1;Touch Only,-20%;Touch or Eye Contact,-15%"
			percent "Unconscious Only" -20%
			percent Uncontrollable -30%
			percent Unreliable "?:1;14 or less,-10%;11 or less,-20%;8 or less,-30%;5 or less,-70%"
			percent Untrainable -40%
			end
		end

	end


end
